//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Hash and create Digest/Plain PKCS-7 message
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define PKCS7D_FILE "pkcs7_dig.bin"
#define PKCS7P_FILE "pkcs7_pln.bin"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
char *Data_for_sign=(char*)"1234567890ABCD";
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTHASH hHash;
 DWORD len,l;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 /*
 //  
 if (!CPHashData(hProv,hHash,(BYTE*)Data_for_sign,strlen(Data_for_sign),0)) {
   printf("CPHashData Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 */
 //  
 len=strlen(Data_for_sign);
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_DATA_SIZE,(BYTE*)&len,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_DATA,(BYTE*)Data_for_sign,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  PKCS7
 len=sizeof(WBuf);
 if (!CPGetHashParam(hProv,hHash,HP_PKCS7_BODY,WBuf,&len,0)) {
   printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(PKCS7D_FILE,WBuf,len);
 //
 CPDestroyHash(hProv,hHash);

 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_BODY,WBuf,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 l=sizeof(len); len=0;
 if (!CPGetHashParam(hProv,hHash,HP_PKCS7_DATA_SIZE,(BYTE*)&len,&l,0)) {
   printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=sizeof(WBuf);
 if (!CPGetHashParam(hProv,hHash,HP_PKCS7_DATA,WBuf,&len,0)) {
   printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(PKCS7P_FILE,WBuf,len);
 //
 CPDestroyHash(hProv,hHash);

 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
